/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.swing;

import java.util.Vector;
import net.sf.jtreemap.swing.SplitBySlice;
import net.sf.jtreemap.swing.SplitStrategy;
import net.sf.jtreemap.swing.TreeMapNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitSquarified
extends SplitStrategy {
    private static final long serialVersionUID = 1711898915283018450L;
    private int w1;
    private int h1;
    private int x;
    private int y;
    private int w;
    private int h;
    private int x2;
    private int y2;
    private int w2;
    private int h2;

    @Override
    public void splitElements(Vector<TreeMapNode> v, Vector<TreeMapNode> v1, Vector<TreeMapNode> v2) {
        double a;
        int mid = 0;
        double weight0 = this.sumWeight(v);
        double b = a = v.get(mid).getWeight() / weight0;
        if (this.w < this.h) {
            int i;
            while (mid < v.size()) {
                double aspect = this.normAspect(this.h, this.w, a, b);
                double q = v.get(mid).getWeight() / weight0;
                if (this.normAspect(this.h, this.w, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            for (i = 0; i <= mid && i < v.size(); ++i) {
                v1.add(v.get(i));
            }
            while (i < v.size()) {
                v2.add(v.get(i));
                ++i;
            }
            this.h1 = (int)Math.round((double)this.h * b);
            this.w1 = this.w;
            this.x2 = this.x;
            this.y2 = (int)Math.round((double)this.y + (double)this.h * b);
            this.w2 = this.w;
            this.h2 = this.h - this.h1;
        } else {
            int i;
            while (mid < v.size()) {
                double aspect = this.normAspect(this.w, this.h, a, b);
                double q = v.get(mid).getWeight() / weight0;
                if (this.normAspect(this.w, this.h, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            for (i = 0; i <= mid && i < v.size(); ++i) {
                v1.add(v.get(i));
            }
            while (i < v.size()) {
                v2.add(v.get(i));
                ++i;
            }
            this.h1 = this.h;
            this.w1 = (int)Math.round((double)this.w * b);
            this.x2 = (int)Math.round((double)this.x + (double)this.w * b);
            this.y2 = this.y;
            this.w2 = this.w - this.w1;
            this.h2 = this.h;
        }
    }

    @Override
    protected void calculatePositionsRec(int x0, int y0, int w0, int h0, double weight0, Vector<TreeMapNode> v) {
        Vector<TreeMapNode> vClone = new Vector<TreeMapNode>(v);
        this.sortVector(vClone);
        if (vClone.size() <= 2) {
            SplitBySlice.splitInSlice(x0, y0, w0, h0, vClone, this.sumWeight(vClone));
            this.calculateChildren(vClone);
        } else {
            Vector<TreeMapNode> v1 = new Vector<TreeMapNode>();
            Vector<TreeMapNode> v2 = new Vector<TreeMapNode>();
            this.x = x0;
            this.y = y0;
            this.w = w0;
            this.h = h0;
            this.splitElements(vClone, v1, v2);
            int prevX2 = this.x2;
            int prevY2 = this.y2;
            int prevW2 = this.w2;
            int prevH2 = this.h2;
            SplitBySlice.splitInSlice(x0, y0, this.w1, this.h1, v1, this.sumWeight(v1));
            this.calculateChildren(v1);
            this.calculatePositionsRec(prevX2, prevY2, prevW2, prevH2, this.sumWeight(v2), v2);
        }
    }

    private double aspect(double big, double small, double a, double b) {
        return big * b / (small * a / b);
    }

    private void calculateChildren(Vector<TreeMapNode> v) {
        for (TreeMapNode node : v) {
            int height;
            if (node.isLeaf()) {
                int height2;
                node.setX(node.getX() + TreeMapNode.getBorder());
                node.setY(node.getY() + TreeMapNode.getBorder());
                int width = node.getWidth() - TreeMapNode.getBorder();
                if (width < 0) {
                    width = 0;
                }
                if ((height2 = node.getHeight() - TreeMapNode.getBorder()) < 0) {
                    height2 = 0;
                }
                node.setHeight(height2);
                node.setWidth(width);
                continue;
            }
            int bSub = TreeMapNode.getBorder() > 1 ? 2 : (TreeMapNode.getBorder() == 1 ? 1 : 0);
            int width = node.getWidth() - bSub;
            if (width < 0) {
                width = 0;
            }
            if ((height = node.getHeight() - bSub) < 0) {
                height = 0;
            }
            TreeMapNode.setBorder(TreeMapNode.getBorder() - bSub);
            this.calculatePositionsRec(node.getX() + bSub, node.getY() + bSub, width, height, node.getWeight(), node.getChildren());
            TreeMapNode.setBorder(TreeMapNode.getBorder() + bSub);
        }
    }

    private double normAspect(double big, double small, double a, double b) {
        double xCalc = this.aspect(big, small, a, b);
        if (xCalc < 1.0) {
            return 1.0 / xCalc;
        }
        return xCalc;
    }
}

