package cards;

/**
 * Demonstrates use of "enum"
 */
public class Card {

	/**
	 * Represents the ranks in a deck of playing cards
	 * 
	 */
	public enum Rank {
		DEUCE, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, JACK, QUEEN, KING, ACE;
	}

	/**
	 * Represents the suits in a deck of playing cards
	 * 
	 */
	public enum Suit {
		CLUBS, DIAMONDS, HEARTS, SPADES;
	}

	private final Rank rank;

	private final Suit suit;

	public Card(Rank rank, Suit suit) {
		this.rank = rank;
		this.suit = suit;
	}

	public Rank rank() {
		return rank;
	}

	public Suit suit() {
		return suit;
	}

	/**
	 * 10, J, Q, K: 10 points A: 15 points all others: 5 points
	 * 
	 * @return the value of the card in the game of Rummy
	 */
	public int getRummyValue() {
		int rummyValue = 0;

		switch (rank) {
		case ACE:
			rummyValue = 15;
			break;
		case KING:
		case QUEEN:
		case JACK:
		case TEN:
			rummyValue = 10;
			break;
		default:
			rummyValue = 5;
		}

		return rummyValue;
	}

	/**
	 * 
	 * @param c
	 *            another Card to compare
	 * @return true iff the cards have the same suit
	 */
	public boolean sameSuit(Card c) {
		return c.suit.equals(suit);
		// return c.suit == suit; // also works because they're enums
	}

	/**
	 * leverages toString() methods of Rank and Suit
	 */
	public String toString() {
		return rank + " of " + suit;
	}

	public static void main(String args[]) {
		Card jackOfDiamonds = new Card(Rank.JACK, Suit.DIAMONDS);
		Card aceOfDiamonds = new Card(Rank.ACE, Suit.DIAMONDS);
		System.out.println(jackOfDiamonds);

		if (jackOfDiamonds.sameSuit(aceOfDiamonds)) {
			System.out.println(jackOfDiamonds + " and " + aceOfDiamonds
					+ " are the same suit.");
		}
		System.out.println("The rummyValue of " + jackOfDiamonds + " is "
				+ jackOfDiamonds.getRummyValue());
	}
}