import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * When a button is pressed, it colors the background of the panel the
 * appropriate color.
 * 
 * Uses an inner class.
 * 
 * @author sarasprenkle
 * 
 */
public class ColoredBackground extends JFrame {

	public ColoredBackground() {
		setTitle("Colored Background - Inner Class");
		setBackground(Color.white);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Container cp = getContentPane();
		cp.setLayout(new FlowLayout());

		// create buttons and add to content pane
		JButton red = new JButton("Red");
		red.setForeground(Color.red);

		JButton green = new JButton("Green");
		green.setForeground(Color.GREEN);
		ColorAction yellowAction = new ColorAction(Color.green);
		cp.add(green);

		JButton blue = new JButton("Blue");
		blue.setForeground(Color.blue);

		ColorAction blueAction = new ColorAction(Color.blue);
		ColorAction redAction = new ColorAction(Color.red);

		green.addActionListener(yellowAction);
		blue.addActionListener(blueAction);
		red.addActionListener(redAction);

		cp.add(red);
		cp.add(blue);

		pack();
		setVisible(true);
	}

	/**
	 * Example of inner class that does event handling
	 * 
	 */
	private class ColorAction implements ActionListener {
		private Color backgroundColor;

		public ColorAction(Color c) {
			backgroundColor = c;
		}

		public void actionPerformed(ActionEvent evt1) {
			// ColorAction does not have a setBackground method
			// but ColorBackground/JFrame does
			setBackground(backgroundColor);
			repaint();
		}

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ColoredBackground cb = new ColoredBackground();
	}

}
