import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * When a button is pressed, it colors the background of the panel the
 * appropriate color.
 * <p>
 * Demonstrates using an anonymous inner class
 * 
 * @author Sara Sprenkle
 * 
 */
public class ColoredBackgroundRefactored extends JFrame {

	public ColoredBackgroundRefactored() {
		setTitle("Colored Background - Anonymous Inner Class");
		setBackground(Color.white);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		Container cp = getContentPane();
		cp.setLayout(new FlowLayout());

		// create buttons and add to content pane
		makeButton("Green", Color.green);
		makeButton("Blue", Color.blue);
		makeButton("Red", Color.red);

		pack();
		setVisible(true);
	}

	/**
	 * Make a button with the given label. Pressing the button will make the
	 * panel background the given background color.
	 * 
	 * @param label
	 * @param backgroundColor
	 */
	private void makeButton(String label, final Color backgroundColor) {
		JButton button = new JButton(label);
		button.setBackground(backgroundColor);
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setBackground(backgroundColor);
				repaint();
			}
		});
		getContentPane().add(button);
	}

	/**
	 * Example of inner class that does event handling
	 * 
	 */
	class ColorAction implements ActionListener {
		private Color backgroundColor;

		public ColorAction(Color c) {
			backgroundColor = c;
		}

		public void actionPerformed(ActionEvent evt1) {
			// ColorAction does not have a setBackground method
			// but ColorBackground/JFrame does
			setBackground(backgroundColor);
			repaint();
		}

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ColoredBackground cb = new ColoredBackground();
	}

}
