package lendables;
import java.util.*;


/**
 * A class that stores a collection of lendable objects.
 * 
 * The only methods used in this class are those that are understood by all
 * classes that extend Lendable.
 */
public class LendableList implements Iterable<Lendable> {
	private Map<String, Lendable> collection;

	/**
	 * Construct an empty collection of Lendable objects
	 */
	public LendableList() {
		collection = new HashMap<String, Lendable>();
	}

	/**
	 * Add a lendable to this collection if it does not already exist.
	 * 
	 * @param aLendable
	 *            The object to be stored in this collection.
	 * @return false if the call number is already in the collection
	 */
	public boolean add(Lendable aLendable) {
		String key = aLendable.getCallNumber();
		if (collection.containsKey(key)) {
			return false;
		} else {
			collection.put(key, aLendable);
			return true;
		}
	}

	/**
	 * Take a Lendable out off this collection if the ID is found
	 */
	public boolean removeLendableWithID(String callNumberToRemove) {
		return (collection.remove(callNumberToRemove) != null);
	}

	/**
	 * Return a Lendable based on the ID
	 */
	public Lendable getLendableWithCallNumber(String callNumber) {
		return collection.get(callNumber);
	}

	/**
	 * Return an iterator over the collection of lendables.
	 */
	public Iterator<Lendable> iterator() {
		return collection.values().iterator();
	}

	public static void main(String[] args) {
		// Build a small collection of Lendables
		LendableList theLendables = new LendableList();
		theLendables.add(new Video("1", "A Man Called Horse"));
		theLendables.add(new CD("2", "Lives in the Balance", "Jackson Browne"));
		theLendables.add(new Book("3", "Karel the Robot", "Rich Pattis"));
		theLendables.add(new CD("4", "Back in the Highlife Again",
				"Steve Winwood"));
		theLendables.add(new Video("5", "Never Say Never"));
		theLendables.add(new Book("6", "A C.S. Tapestry", "Owen Astrachan"));
		theLendables.add(new CD("7", "Revolver", "Beatles"));

		theLendables.removeLendableWithID("3");
		theLendables.removeLendableWithID("5");

		for (Lendable item : theLendables) {
			System.out.println(item);
		}
	}
}

/*
Expected output from test driver

CD: 7 'Revolver': available
CD: 2 'Lives in the Balance': available
CD: 4 'Back in the Highlife Again': available
Book: 6 'A C.S. Tapestry': available
Video: 1 'A Man Called Horse': available

*/