package lendables;

public class Tester {

	// A Test Tester for Lendable
	public static void main(String[] args) {
		Video v1 = new Video("V1", "A Man Called Horse");
		Lendable c1 = new CD("CD1", "Lives in the Balance", "Jackson Browne");
		Book b1 = new Book("B1", "Karel the Robot", "Rich Pattis");
		Lendable c2 = new CD("CD2", "Back in the Highlife Again", "Steve Winwood");
	
		// Build a small collection of Lendables
		LendableList theLendables = new LendableList();
		theLendables.add(b1);
		theLendables.add(c1);
		theLendables.add(v1);
		theLendables.add(c2);
	
		String borrowerID = "1234";
		Borrower aBorrower = new Borrower(borrowerID, "Jo");
	
		System.out.println("First test a few accessor methods");
		System.out.println("1234? " + aBorrower.getID());
		System.out.println("  Jo? " + aBorrower.getName());
		System.out.println();
	
		System.out
				.println("Show toString version of Borrower with nothing borrowed:");
		System.out.println(aBorrower.toString());
	
		if (aBorrower.canBorrow(theLendables)) {
			b1.checkSelfOut(aBorrower.getID());
			aBorrower.borrowLendable(b1);
		}
	
		System.out.println();
		System.out.println("Borrower should now have the following Lendable:");
		System.out.println(v1);
		System.out.println();
		System.out
				.println("The next few lines show the modified state of the borrower");
		System.out.println();
		System.out.println(aBorrower.toString());
	
		System.out.println();
		System.out.println("Try to borrow up to 4, should fail with " + c2);
	
		if (aBorrower.canBorrow(theLendables)) {
			b1.checkSelfOut(aBorrower.getID());
			aBorrower.borrowLendable(c1);
		}
		if (aBorrower.canBorrow(theLendables)) {
			b1.checkSelfOut(aBorrower.getID());
			aBorrower.borrowLendable(v1);
		}
		if (aBorrower.canBorrow(theLendables)) {
			b1.checkSelfOut(aBorrower.getID());
			aBorrower.borrowLendable(c2);
		} else {
			System.out.println("Could not borrow " + c2);
		}
	
		System.out.println(aBorrower.toString());
	}
	
	/*
	Expected output from test driver

	First test a few accessor methods
	1234? 1234
	  Jo? Jo

	Show toString version of Borrower with nothing borrowed:
	Borrower: Jo, 1234, $0.00
	[
	]

	Borrower should now have the following Lendable:
	Video: V1 'A Man Called Horse': available

	The next few lines show the modified state of the borrower

	Borrower: Jo, 1234, $0.00
	[
	 1. Book: B1 'Karel the Robot': due 2008/09/14, 1234
	]

	Try to borrow up to 4, should fail with CD: CD2 'Back in the Highlife Again': available
	Could not borrow CD: CD2 'Back in the Highlife Again': available
	Borrower: Jo, 1234, $0.00
	[
	 1. Book: B1 'Karel the Robot': due 2008/09/14, 1234
	 2. CD: CD1 'Lives in the Balance': available
	 3. Video: V1 'A Man Called Horse': available
	]

	*/

}
