import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * 
 * @author sarasprenkle
 * 
 */
public class ColoredBackground extends JFrame {

	public ColoredBackground() {
		setTitle("Colored Background");
		setBackground(Color.white);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Container cp = getContentPane();
		cp.setLayout(new FlowLayout());

		// create buttons and add to content pane
		JButton red = new JButton("Red");
		red.setForeground(Color.red);
		
		JButton yellow = new JButton("Yellow");
		yellow.setBackground(Color.yellow);
		ColorAction yellowAction = new ColorAction(Color.yellow);
		cp.add(yellow);

		JButton blue = new JButton("Blue");
		blue.setForeground(Color.blue);

		ColorAction blueAction = new ColorAction(Color.blue);
		ColorAction redAction = new ColorAction(Color.red);

		yellow.addActionListener(yellowAction);
		blue.addActionListener(blueAction);
		red.addActionListener(redAction);

		cp.add(red);
		cp.add(blue);

		pack();
		setVisible(true);
	}

	/**
	 * Example of inner class that does event handling
	 * 
	 */
	class ColorAction implements ActionListener {
		private Color backgroundColor;

		public ColorAction(Color c) {
			backgroundColor = c;
		}

		public void actionPerformed(ActionEvent evt1) {
			// ColorAction does not have a setBackground method
			// but ColorBackground/JFrame does
			setBackground(backgroundColor);
			repaint();
		}

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ColoredBackground cb = new ColoredBackground();
	}

}
