import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

/**
 * Demonstrates use of Arrays.sort with a Comparator class
 * @author sarasprenkle
 * 
 */
public class Chicken implements Comparable {

	protected String name;

	protected double weight;

	/** the chicken's height in centimeters */
	protected int height;
	
	protected boolean is_female;
	
	private Date birthdate;

	/**
	 * By default, chickens are female and their birthdate is today in this implementation.
	 * @param name
	 * @param height
	 * @param weight
	 */
	public Chicken(String name, int height, double weight) {
		this( name, height, weight, true, new Date());
	}
	
	/**
	 * 
	 * @param name
	 * @param height
	 * @param weight
	 * @param is_female
	 * @param birthdate
	 */
	public Chicken(String name, int height, double weight, boolean is_female, Date birthdate) {
		this.name = name;
		this.weight = weight;
		this.height = height;
		this.is_female = is_female;
		this.birthdate = birthdate;
	}
	
	public Chicken(String name, int height, double weight, boolean is_female ) {
		this( name, height, weight, is_female, new Date());
	}

	//
	// ----------- GETTER METHODS ------------
	// (also Accessor methods)

	/**
	 * @return the height of the chicken, in centimeters
	 */
	public int getHeight() {
		return height;
	}

	public double getWeight() {
		return weight;
	}

	public Date getBirthdate() {
		return birthdate;
	}
	
	/**
	 * 
	 * @return the name of my Chicken
	 */
	public String getName() {
		return name;
	}

	public String toString() {
		return name + ":\n \theight: " + height + " cm \n\tweight: " + weight
				+ "lbs " + "\n\tbirthdate: " + birthdate;
	}
	
	//
	// ----------INHERITED METHODS FROM COMPARABLE -------------
	//
	/**
	 * Sorts chickens by height, then by weight
	 */
	public int compareTo(Object otherObject) {
		Chicken other = (Chicken) otherObject;
		if (height < other.getHeight())
			return -1;
		if (height > other.getHeight())
			return 1;
		if (weight < other.getWeight())
			return -1;
		if (weight > other.getWeight())
			return 1;
		/*
		 * If same height and weight, sort by name return
		 * name.compareTo(otherObject.getName());
		 */
		return 0;
	}

	
	//
	// ------------- MUTATORS -----------
	//

	public void feed() {
		weight += .3;
		height += 1;
	}

	public void sick() {
		weight -= .5;
		height -= 1;
	}

	//
	// ------------- SETTERS ----------
	//

	/**
	 * @param n
	 *            the name of the chicken
	 */
	public void setName(String n) {
		name = n;
	}

	/**
	 * @param h
	 *            the height of the chicken, in cm
	 */
	public void setHeight(int h) {
		height = h;
	}

	public void setBirthdate(Date birthdate) {
		this.birthdate = birthdate;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy");
		Chicken[] chickens = new Chicken[4];
		try {
		chickens[0] = new Chicken("Foghorn", 38, 5.0, false, formatter.parse("Jun 1 1998"));
		chickens[1] = new Chicken("Momma", 28, 4.0, true, formatter.parse("Oct 7 2000"));
		chickens[2] = new Chicken("Baby", 10, 1, false, formatter.parse("Jan 4 2006"));
		chickens[3] = new Chicken("Big Baby", 10, 1.5, true, formatter.parse("Dec 10 2005"));
		} catch( Exception e ) {
			e.printStackTrace();
		}
		
		// need to import java.util.Arrays
		Arrays.sort(chickens, new ChickenComparator() );

		for (int i = 0; i < chickens.length; i++) {
			System.out.println(chickens[i]);
		}
	}

}
