/**
 * A simple Java class that models a Chicken. The state of the chicken is its
 * name, height and weight.
 * 
 * @author Sara Sprenkle
 */
public class Chicken {

	// ------------ INSTANCE VARIABLES -------------------

    /** the chicken's name */
	private String name;
	
    /** the height of the chicken in centimeters */
	private int height;
    
    /** the weight of the chicken in pounds */
	private double weight;
    
    public static String DEFAULT_NAME = "BUBBA";

    
    public Chicken(String name, int height, double weight) {
		this.name = name;
		this.height = height;
		this.weight = weight;
	}
    
    /**
     * Default name is Bubba
     */
    public Chicken( int height, double weight ) {
        this( DEFAULT_NAME, height, weight);
    }
    
    /**
     * Returns the chicken's name, weight, and height.
     */
    public String toString() {
        String rep = "Name: " + name + "\n";
        rep += "Weight: " + weight + "\n";
        rep += "Height: " + height;
        return rep;
    }

    public boolean equals(Object o) {
        Chicken other = (Chicken) o;
        
        if( ! other.getName().equals(this.getName() ) ) {
            return false;
        }
        
        if( other.getHeight() != this.getHeight() ) {
            return false;   
        }
        
        if( other.getWeight() != this.getWeight() ) {
            return false;   
        }
        
        return true;
    }
    
	//
	// ----------- GETTER METHODS ------------
	// (also Accessor methods)

	/**
	 * @return the height of the chicken, in centimeters
	 */
	public int getHeight() {
		return height;
	}

	public double getWeight() {
		return weight;
	}

	public String getName() {
		return name;
	}
    

	//
	// ------------- MUTATORS -----------
	//

	public void feed() {
		weight += .2;
		height += 1;
	}
	
	//
	// ------------- SETTERS ----------
	//

	/**
	 * @param n
	 *            the name of the chicken
	 */
	public void setName(String n) {
		name = n;
	}

	/**
	 * @param h
	 *            the height of the chicken, in cm
	 */
	public void setHeight(int h) {
		height = h;
	}
    
    /**
	 * @param w
	 *            the weight of the chicken, in pounds
	 */
	public void setWeight(double w) {
		weight = w;
	}
    
	/**
	 * @param args
	 *            the command-line arguments
	 */
	public static void main(String args[]) {
        Chicken one = new Chicken("Fred", 38, 2.0);
        Chicken two = new Chicken("Sallie Mae", 45, 3.0);
        
        System.out.println(one.getName() + " weighs " + one.getWeight() );
        one.feed();
        System.out.println(one.getName() + " ate, so he now weighs " + one.getWeight() );
        
        System.out.print(two.getName() + " is now ");
        two.setName("The Divine Miss Sallie Mae");
        System.out.println(two.getName());
        
        // test toString method
        System.out.println(one);
        
        System.out.println( one.equals(two) );
		
	}

}