package cards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Represents a deck of playing cards
 * 
 * @author Sara Sprenkle and CS209
 * 
 */
public class Deck {

	// define our variable as an interface variable, List.
	// Note that only Card objects can be put into the list or taken out of the
	// list.
	/** a list of Card objects */
	private List<Card> deck;

	/**
	 * Creates a new, shuffled deck of cards
	 */
	public Deck() {
		// Assign the List variable to the ArrayList implementation.
		deck = new ArrayList<Card>();
		restart(true);
	}
	
	/**
	 * Creates a new deck of cards
	 * @param isShuffled - true if the cards should be shuffled
	 */
	public Deck(boolean isShuffled) {
		deck = new ArrayList<Card>();
		restart(isShuffled);
	}

	/**
	 * Restart the deck from the beginning.
	 * @param isShuffled - true if the cards should be shuffled
	 */
	public void restart(boolean isShuffled) {
		// removes all the Cards from the deck
		deck.clear();

		// Use the enums defined in the Card class
		for (Card.Suit suit : Card.Suit.values()) {
			for (Card.Rank rank : Card.Rank.values()) {
				Card c = new Card(rank, suit);
				deck.add(c);
			}
		}
		
		if( isShuffled ) {
			shuffle();
		}
	}

	/**
	 * Display the contents of the deck.
	 */
	public void display() {
		// System.out.println(deck);
		for (Card c : deck) {
			System.out.println(c);
		}
	}
	
	/**
	 * 
	 */
	public void shuffle() {
		Collections.shuffle(deck);
	}
	
	public Card draw() {
		return deck.remove(0);
	}

	public List<Card> deal(int numCards) {
		List<Card> hand = new ArrayList<Card>();
		for( int i=0; i < numCards; i++ ) {
			hand.add(draw());
		}
		return hand;
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Deck d = new Deck();
		d.display();
	}

}
