import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Demonstrates using an anonymous inner class
 * @author Sara Sprenkle
 * 
 */
public class ColoredBackground2 extends JFrame {

	public ColoredBackground2() {
		setTitle("Colored Background");
		setBackground(Color.white);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		Container cp = getContentPane();
		cp.setLayout(new FlowLayout());

		// create buttons and add to content pane
		makeButton("Yellow", Color.yellow);
		makeButton("Blue", Color.blue);
		makeButton("Red", Color.red);

		pack();
		setVisible(true);
	}


	/**
	 * 
	 * @param label
	 * @param backgroundColor
	 */
	private void makeButton(String label, final Color backgroundColor) {
		JButton button = new JButton(label);
		button.setBackground(backgroundColor);
		button.addActionListener(new ActionListener() {
			   public void actionPerformed(ActionEvent evt)
			   {
		   		setBackground(backgroundColor);
				repaint();
			   }
			});
		getContentPane().add(button);
	}

	/**
	 * Example of inner class that does event handling
	 * 
	 */
	class ColorAction implements ActionListener {
		private Color backgroundColor;

		public ColorAction(Color c) {
			backgroundColor = c;
		}

		public void actionPerformed(ActionEvent evt1) {
			// ColorAction does not have a setBackground method
			// but ColorBackground/JFrame does
			setBackground(backgroundColor);
			repaint();
		}

	}
	

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ColoredBackground cb = new ColoredBackground();
	}

}
