package examples;

/**
 * Example demonstrates a more sophisticated enumerated type.
 *
 */
public class PlanetTest {

	public enum Planet {
		MERCURY(3.302e+23, 2.439e6),
		VENUS(4.869e+24, 6.0518e6),
		EARTH(5.976e+24, 6.37814e6),
		MARS(6.421e+23, 3.3972e6),
		JUPITER(1.9e+27, 7.1492e7),
		SATURN(5.688e+26, 6.0268e7),
		URANUS(8.686e+25, 2.5559e7),
		NEPTUNE(1.024e+26, 2.4746e7);

		private final double mass;
		private final double radius;
		private final double surfaceGravity;

		private static final double G = 6.67300E-11;

		// Note: Package-private; Can't be more visible than package-private
		Planet(double mass, double radius) {
			this.mass = mass;
			this.radius = radius;
			surfaceGravity = G * mass / (radius * radius);
		}

		public double mass() {
			return mass;
		}

		public double radius() {
			return radius;
		}

		public double surfaceGravity() {
			return surfaceGravity;
		}

		public double surfaceWeight(double mass) {
			return mass * surfaceGravity; // F = ma
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		double earthWeight = 150;
        double mass = earthWeight/Planet.EARTH.surfaceGravity();
        for (Planet p : Planet.values())
           System.out.printf("Your weight on %s is %10.4f%n",
                             p, p.surfaceWeight(mass));

	}

}
