package employee;

import java.util.Arrays;

/**
 * @author sprenkle
 * 
 */
public class Employee implements Comparable<Employee> {

	private int id;
	private String name;
	private int age;

	/**
	 * @param id
	 * @param name
	 * @param age
	 */
	public Employee(int id, String name, int age) {
		super();
		this.id = id;
		this.name = name;
		this.age = age;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuffer rep = new StringBuffer(getName());
		rep.append("\n\t Employee ID: " + this.getId());
		rep.append("\n\t Age:" + this.getAge());
		return rep.toString();
	}

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setEmpId(int empId) {
		this.id = empId;
	}

	/**
	 * @return the employee's name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            -- the name of the employee
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the age
	 */
	public int getAge() {
		return age;
	}

	/**
	 * @param age
	 *            -- the age of the employee
	 */
	public void setAge(int age) {
		this.age = age;
	}

	/**
	 * Compares employees by their ids
	 */
	@Override
	public int compareTo(Employee o) {
		// note how this simple statement does what we want
		return this.id - o.id;
	}

	public static void main(String[] args) {
		Employee a = new Employee(12, "Homer J. Simpson", 38);
		Employee b = new Employee(1, "Charles Montgomery Burns", 104);
		Employee c = new Employee(3, "Waylon Smithers", 43);
		Employee d = new Employee(14, "Carl Carlson", 38);
		Employee e = new Employee(15, "Lenny Leonard", 38);

		System.out.println("Comparing " + a.getName() + " with " + b.getName()
				+ ": " + a.compareTo(b));

		System.out.println("\nSorted: ");
		Employee[] employees = { a, b, c, d, e };
		Arrays.sort(employees);
		for (Employee emp : employees) {
			System.out.println(emp);
		}
	}
}
