/**
 * 
 */
package media.tests;

import static org.junit.Assert.*;

import java.util.GregorianCalendar;

import media.DVD;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * @author sprenkle
 *
 */
public class MediaItemTest {

	DVD mydvd;
	
	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		mydvd = new DVD("That Thing You Do!", 6480, new GregorianCalendar(
				1996, 9, 4), "PG", 3600);
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for {@link media.MediaItem#getCopyrightDate()}.
	 */
	@Test
	public void testGetCopyrightDate() {
		assertEquals(new GregorianCalendar(1996, 9, 4), mydvd.getCopyrightDate());
	}

	/**
	 * Test method for {@link media.MediaItem#getCopyrightYear()}.
	 */
	@Test
	public void testGetCopyrightYear() {
		assertEquals(1996, mydvd.getCopyrightYear());
	}

	/**
	 * Test method for {@link media.MediaItem#getFormattedPlayTime()}.
	 */
	@Test
	public void testGetFormattedPlayTime() {
		assertEquals("02:48:00", mydvd.getFormattedPlayTime());
	}

}
