package media.tests;

import static org.junit.Assert.*;

import java.util.Calendar;
import java.util.GregorianCalendar;

import media.BookOnTape;
import media.DVD;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * Tests of the MediaItem class
 * 
 * @author Sara Sprenkle
 * 
 */
public class MediaItemTest {

	private DVD dvd1;
	private BookOnTape bot1;

	@Before
	public void setUp() throws Exception {
		Calendar cal = new GregorianCalendar();
		cal.set(Calendar.YEAR, 2003);

		dvd1 = new DVD("Master and Commander: Far Side of the World", 8280, cal
				.getTime(), "PG-13", 0);

		cal.set(Calendar.YEAR, 2005);
		cal.set(Calendar.MONTH, Calendar.JULY);
		cal.set(Calendar.DATE, 16);

		bot1 = new BookOnTape("Harry Potter and the Half-Blood Prince", 21900,
				cal.getTime(), "J.K. Rowling", "Jim Dale");
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testGetPlayingTime() {

		assertEquals("2:18:00", dvd1.getPlayingTime());

		assertEquals("6:05:00", bot1.getPlayingTime());
	}

	@Test
	public void testGetRating() {
		fail("Not yet implemented");
	}

	@Test
	public void testSomethingElse() throws Exception {
	}
	
}
