import java.util.Arrays;

/**
 * A simple Java class that models a Chicken. The state of the chicken is its
 * name, height and weight.
 * 
 * @author CSCI209
 */
public class Chicken implements Comparable {

	// ------------ INSTANCE VARIABLES -------------------

	/** the chicken's name */
	protected String name;

	/** the height of the chicken in centimeters */
	protected int height;

	/** the weight of the chicken in pounds */
	protected double weight;

	/** true iff the chicken is a female */
	protected boolean isFemale;

	/** default name of a Chicken */
	public static final String DEFAULT_NAME = "BUBBA";

	/**
	 * Creates a fully-specified Chicken object
	 * 
	 * @param name
	 *            the name of the Chicken
	 * @param height
	 *            the Chicken's height, in cm
	 * @param weight
	 *            the Chicken's weight, in pounds
	 * @param isFemale
	 *            if the Chicken is female (true/false)
	 */
	public Chicken(String name, int height, double weight, boolean isFemale) {
		this.name = name;
		this.height = height;
		this.weight = weight;
		this.isFemale = isFemale;
	}

	/**
	 * Assumes Chickens are females
	 * 
	 * @param name
	 *            the name of the Chicken
	 * @param height
	 *            the Chicken's height, in cm
	 * @param weight
	 *            the Chicken's weight, in pounds
	 */
	public Chicken(String name, int height, double weight) {
		this(name, height, weight, true);
	}

	/**
	 * Default name is Bubba; Assumes Chickens are female
	 * 
	 * @param height
	 *            the Chicken's height, in cm
	 * @param weight
	 *            the Chicken's weight, in pounds
	 */
	public Chicken(int height, double weight) {
		this(DEFAULT_NAME, height, weight, true);
	}

	/**
	 * Format of the string representation: Chicken name: <name> weight:
	 * <weight> height: <height> [male/female]
	 */
	@Override
	public String toString() {
		StringBuffer rep = new StringBuffer("Chicken name: ");
		rep.append(name);
		rep.append("\nweight: ");
		rep.append(weight);
		rep.append("\nheight: ");
		rep.append(height);
		rep.append("\n");
		rep.append(isFemale ? "female" : "male"); // Java ternary operator; also
													// available in C
		return rep.toString();
	}

	/**
	 * Determines if two Chickens are equivalent, based on their name, height,
	 * weight, and gender.
	 */
	public boolean equals(Object o) {

		if (o == this) {
			return true;
		}

		Chicken other = (Chicken) o;

		if (!other.getName().equals(this.getName())) {
			return false;
		}

		if (other.getHeight() != this.getHeight()) {
			return false;
		}

		if (other.weight != this.weight) {
			return false;
		}

		return this.isFemale == other.isFemale;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	/**
	 * Compares the chickens by their height
	 */
	@Override
	public int compareTo(Object o) {
		if (!(o instanceof Chicken)) {
			return 1;
		}
		Chicken otherChicken = (Chicken) o;
		if (otherChicken.getHeight() > this.getHeight()) {
			return -1;
		} else if (otherChicken.getHeight() < this.getHeight()) {
			return 1;
		}
		return 0;
	}

	//
	// ----------- GETTER METHODS ------------
	// (also Accessor methods)

	/**
	 * @return the height of the chicken, in centimeters
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * 
	 * @return the weight of the chicken, in pounds
	 */
	public double getWeight() {
		return weight;
	}

	/**
	 * 
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * 
	 * @return whether this chicken is a female
	 */
	public boolean isFemale() {
		return isFemale;
	}

	//
	// ------------- MUTATORS -----------
	//

	/**
	 * Feed the chicken. Side effects: the chicken grows in weight and height.
	 */
	public void feed() {
		weight += .2;
		height += 1;
	}

	//
	// ------------- SETTERS ----------
	//

	/**
	 * Changes the name of the chicken
	 * 
	 * @param n
	 *            the name of the chicken
	 */
	public void setName(String n) {
		name = n;
	}

	/**
	 * Sets the height of the chicken
	 * 
	 * @param h
	 *            the height of the chicken, in cm
	 */
	public void setHeight(int h) {
		height = h;
	}

	/**
	 * Sets the weight of the chicken
	 * 
	 * @param w
	 *            the weight of the chicken, in pounds
	 */
	public void setWeight(double w) {
		weight = w;
	}

	/**
	 * @param args
	 *            the command-line arguments
	 */
	public static void main(String args[]) {
		Chicken one = new Chicken("Fred", 38, 2.0, false);
		Chicken two = new Chicken("Sallie Mae", 45, 3.0);
		Chicken female = new Chicken("Lucille", 38, 2.0, true);

		System.out.println(one.getName() + " weighs " + one.getWeight());
		one.feed();
		System.out.println(one.getName() + " ate, so he now weighs "
				+ one.getWeight());

		System.out.print(two.getName() + " is now ");
		two.setName("The Divine Miss Sallie Mae");
		System.out.println(two.getName());

		// test toString method
		System.out.println(one);

		System.out.println(one + " equal to " + two + "? " + one.equals(two));
		System.out.println(one + " equal to " + female + "? "
				+ one.equals(female));
		System.out.println(two + " equal to " + two + "? " + two.equals(two));

		Chicken[] chickens = new Chicken[3];
		chickens[0] = one;
		chickens[1] = two;
		chickens[2] = female;

		// sort the chickens
		Arrays.sort(chickens);
		// print the chickens in sorted order (by height)
		for (Chicken c : chickens) {
			System.out.println(c);
		}

	}

}