
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import bins.Disk;


public class DiskTest {

	private Disk d1;
	private Disk d2;
	private Disk d3;


	@Before
	public void setUp() {
		d1 = new Disk();
		d2 = new Disk();
		d3 = d1;
	}

	@Test
	public void testEquals() {
		assertEquals(d1, d1);
		assertTrue(d1.equals(d3));
		assertTrue(!d1.equals(d2));
	}

	@Test
	public void testFreeSpace() {
		Disk tmp = new Disk();
		
		assertEquals(Disk.GIGABYTE, tmp.freeSpace());
		tmp.add(Disk.GIGABYTE / 2);
		assertEquals(Disk.GIGABYTE / 2, tmp.freeSpace());
		tmp.add(Disk.GIGABYTE / 2);
		assertEquals(0, tmp.freeSpace());
	}


}
