package examples;

import java.io.*;
import java.util.Scanner;

/**
 * Demonstrate use of PrintWriter/Scanner with merchandise invoices.
 * 
 */
public class InvoiceUsingText {

	public static void main(String[] args) throws IOException {

		final String FILENAME = "invoice.dat";

		// write the data out
		PrintWriter out = new PrintWriter(FILENAME);

		double[] prices = { 19.99, 9.99, 15.99, 3.99, 4.99 };
		int[] units = { 12, 8, 13, 29, 50 };
		String[] descs = { "Java T-shirt", "Java Mug", "Java Beach Towel",
				"Java Pin", "Java Key Chain" };

		for (int i = 0; i < prices.length; i++) {
			out.print(prices[i]);
			out.print('\t');
			out.print(units[i]);
			out.print('\t');
			out.println(descs[i]);
		}
		out.close();

		// read it in again
		Scanner in = new Scanner(new FileReader(FILENAME));

		double price;
		int unit;
		String desc;
		double total = 0.0;

		while (in.hasNext()) {
			price = in.nextDouble();
			unit = in.nextInt();
			in.skip("\t"); // eat tab
			desc = in.nextLine();
			System.out.println("You've ordered " + unit + " units of " + desc
					+ " at $" + price);
			total = total + unit * price;
		}
		in.close();

		// 1.5+ way
		System.out.printf("For a TOTAL of $%10.2f\n", total);
		// OR
		System.out.format("For a TOTAL of $%.2f", total);
	}
}
