package examples;

import java.util.Set;
import java.util.HashSet;

/**
 * From <em>Effective Java</em> "Can you spot the bug?"
 * 
 * Fixed example of Bigram.java
 * 
 * @author Joshua Bloch
 */
public class BigramFixed {
	private final char first;
	private final char second;

	public BigramFixed(char first, char second) {
		this.first = first;
		this.second = second;
	}

	@Override
	public boolean equals(Object o) {
		if (! (o instanceof BigramFixed))
			return false;
		BigramFixed b = (BigramFixed) o;
		return b.first == first && b.second == second;
	}

	public int hashCode() {
		return 31 * first + second;
	}

	public static void main(String[] args) {
		Set<BigramFixed> s = new HashSet<BigramFixed>();
		for (int i = 0; i < 10; i++)
			for (char ch = 'a'; ch <= 'z'; ch++)
				s.add(new BigramFixed(ch, ch));
		System.out.println(s.size());
	}
}