import javax.swing.*;
import java.awt.*;

/**
 * Demonstrates flexibility of layout
 */
public class FlexibleLayout {

	public static void main(String args[]) {
		JFrame frame = new JFrame();
		frame.setTitle("Demonstrate Flexibility");

		Container contentPane = frame.getContentPane();

		// create labels for each of the parts of the pane
		JLabel north = new JLabel("North");
		JLabel west = new JLabel("West");
		JLabel east = new JLabel("East");

		contentPane.add(north, BorderLayout.NORTH);
		contentPane.add(west, BorderLayout.WEST);
		contentPane.add(east, BorderLayout.EAST);

		// create buttons and add to button panel
		Button b1 = new Button("One!");
		Button b2 = new Button("a-Two!");
		Button b3 = new Button("a-Three!");

		JPanel buttonPanel = new JPanel();

		// add the buttons to the new JPanel
		// this will use the default flow layout manager
		buttonPanel.add(b1);
		buttonPanel.add(b2);
		buttonPanel.add(b3);

		// add the panel to the South part of the JFrame content pane
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		frame.pack();
		frame.setVisible(true);
	}
}