package examples;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * @author sprenkle
 * 
 */
public class TestGUI extends JFrame {

	/**
	 * @throws HeadlessException
	 */
	public TestGUI() throws HeadlessException {
		setTitle("Test GUI");
		initComponents();
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		pack();
		setVisible(true);
	}

	private void initComponents() {
		JTextField tfield = new JTextField("default text");
		JLabel tf_label = new JLabel("Enter text:");
		JPanel tf_panel = new JPanel();

		tfield.addKeyListener(new KeyAdapter() {
			@Override
			public void keyTyped(KeyEvent e) {
				System.out.println("Note: Key event from " + e.getComponent());
			}
		});

		tf_panel.add(tf_label);
		tf_panel.add(tfield);

		Container contentPane = getContentPane();
		contentPane.setLayout(new FlowLayout());
		contentPane.add(tf_panel);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		TestGUI gui = new TestGUI();
	}

}
