package media;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

/**
 * Driver for User Interface
 * 
 */
public class UserInterface {
	
	private Scanner scanner;
	
	// needs your object that contains MediaItems


    
	public static final String CHOOSE_OPTION = "Choose one of the above options: ";
	static Map<Integer, String> options = new HashMap<Integer, String>();
	static {
		options.put(1, "Print collection");
		options.put(2, "Sort collection");
		options.put(3, "Add an item");
		options.put(4, "Check item into/out of collection");
		options.put(5, "Quit");
	}

	static int MAX_OPTION = options.size();

	public UserInterface() {
		scanner = new Scanner(System.in);
	}
	
    /**
     * Display the options
     */
	public void displayMenu() {
		System.out.println("--------------OPTIONS--------------");
		for (Integer option : options.keySet()) {
			System.out.println("\t" + option + ": " + options.get(option));
		}
		System.out.print(CHOOSE_OPTION);
	}

	/**
	 * 
	 * @param option
	 */
	private void doOption(int option) {
		switch (option) {
		case(1):
			displayCollection();
		}
	}

	/**
	 * Display the collection to the user in a nicely formatted way.
	 */
	private void displayCollection() {
		
	}
	
	/**
	 * Add a new item to the collection.
	 * Need to get input from the user...
	 */
	public void addNewItem() {
		
	}
	
	/**
	 * Get the user's menu choice from the console.
	 * Handles bad input as best as we can.
	 * @return the chosen menu choice.
	 */
	public int getUserMenuChoice() {
		while (!scanner.hasNextInt()) {
			System.out.println("Not a valid option");
			scanner.next();
			System.out.print(CHOOSE_OPTION);
		}

		int userChoice = scanner.nextInt();
		scanner.nextLine(); // get the newline after the int
		return userChoice;
	}
	
	/**
	 * Clean up UI's resources ...
	 */
	public void shutdown() {
		System.out.println("Thank you.  Come again.");
		scanner.close();
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		UserInterface ui = new UserInterface();
		
		int option = 0;
		while (option != MAX_OPTION) {
			ui.displayMenu();

			option = ui.getUserMenuChoice();
			
			if (option <= 0 || option > MAX_OPTION) {
				System.out.println("Not a valid option");
			} else {
				ui.doOption(option);
			}
		}
		ui.shutdown();
	}

}
