/**
 * 
 */
package examples;

import java.util.HashSet;
import java.util.Set;

/**
 * From the array of command-line arguments, identify the duplicates. Example of
 * using the Set interface and its implementation.
 * 
 * @author CSCI209
 */
public class FindDuplicates {

	/**
	 * From the array of command-line arguments, identify the duplicates
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		Set<String> noDuplicates = new HashSet<String>();

		for (String arg : args) {
			if (!noDuplicates.add(arg)) {
				System.out.println("Found a duplicate: " + arg);
			}
		}

		if (!noDuplicates.isEmpty()) {
			System.out.println("The unique arguments are");
			for (String nod : noDuplicates) {
				System.out.println(nod);
			}
		}
	}

}
