package employee;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * @author sprenkle
 * 
 */
public class EmployeeNameComparator implements Comparator<Employee> {

	/**
	 * Compare Employees by their names
	 */
	@Override
	public int compare(Employee o1, Employee o2) {
		return o1.getName().compareTo(o2.getName());
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Employee a = new Employee(12, "Homer J. Simpson", 38);
		Employee b = new Employee(1, "Charles Montgomery Burns", 104);
		Employee c = new Employee(3, "Waylon Smithers", 43);
		Employee d = new Employee(14, "Carl Carlson", 38);
		Employee e = new Employee(15, "Lenny Leonard", 38);

		System.out.println("Comparing " + a.getName() + " with " + b.getName()
				+ ": " + a.compareTo(b));

		List<Employee> employees = new ArrayList<Employee>();
		employees.add(a);
		employees.add(b);
		employees.add(c);
		employees.add(d);
		employees.add(e);

		System.out.println("\nSorted natural order: ");
		Collections.sort(employees);

		for (Employee emp : employees) {
			System.out.println(emp);
		}

		System.out.println("\nSorted by name: ");

		Collections.sort(employees, new EmployeeNameComparator());

		for (Employee emp : employees) {
			System.out.println(emp);
		}
	}
}
