/**
 * A simple Java class that models a Chicken. The state of the chicken is its
 * name, height and weight.
 * 
 * @author Sara Sprenkle
 */
public class Chicken {

    // ------------ INSTANCE VARIABLES -------------------

    private String name;
	
    /** the height of the chicken in centimeters */
    private int height;
    
    /** the weight of the chicken in pounds */
    private double weight;
    
    /**
     * Create a new Chicken object with the charactistics as specified by the
     * parameters.
     * Default name: "Bubba"
     * @param height the height of the chicken in centimeters
     * @param weight the weight of the chicken in pounds
     */
    public Chicken(int height, double weight) {
        // if the user doesn't specify a name, let's make it Bubba
        this.name = "Bubba";
        this.height = height;
        this.weight = weight;
    }
    
    /**
     * Create a new Chicken object with the charactistics as specified by the
     * parameters.
     * @param height the height of the chicken in centimeters
     * @param weight the weight of the chicken in pounds
     */
    public Chicken(String name, int height, double weight) {
	this.name = name;
	this.height = height;
	this.weight = weight;
    }

    //
    // ----------- GETTER METHODS ------------
    // (also Accessor methods)

    /**
     * @return the height of the chicken, in centimeters
     */
    public int getHeight() {
	return height;
    }
    
    public double getWeight() {
	return weight;
    }
    
    public String getName() {
	return name;
    }
    
    //
    // ------------- MUTATORS -----------
    //
    
    public void feed() {
	weight += .3;
	height += 1;
    }
    
    //
    // ------------- SETTERS ----------
    //
    
    /**
     * @param n
     *            the name of the chicken
     */
    public void setName(String n) {
	name = n;
    }
    
    /**
     * @param h
     *            the height of the chicken, in cm
     */
    public void setHeight(int h) {
	height = h;
    }
    
    /**
     * @param w
     *            the weight of the chicken, in pounds
     */
    public void setWeight(double w) {
	weight = w;
    }
    
    /**
     * @param args
     *            the command-line arguments
     */
    public static void main(String[] args) {        
        // Fred, weight: 2.0, height: 38
        //Sallie Mae, weight: 3.0, height: 45
        //Momma, weight: 6.0, height: 83
        Chicken fred = new Chicken("Fred", 38, 2.0);
        Chicken sallie = new Chicken("Sallie Mae", 45, 3.0);
        
        // fatten up that chicken
        for( int i=0; i < 10; i++ ) {  
            fred.feed();
        }
        fred.setName("Garrett");
        System.out.println(fred);
    }
}