package examples;

import java.util.Scanner;

/**
 * A program that shows reading in from the console and doing arithmetic.
 * 
 * @author Sara Sprenkle
 */
public class ConsoleIODemo {

	/**
	 * @param args
	 *            not used in this program
	 */
	public static void main(String[] args) {
		System.out.println("Test Program");

		// open the Scanner on the console input, System.in
		Scanner scan = new Scanner(System.in);
		scan.useDelimiter("\n"); // breaks up stream by lines, useful for console I/O


		String widthPrompt = "Please enter the width of a rectangle (as an integer): ";
		System.out.print(widthPrompt);
		// check for bad input
		while (!scan.hasNextInt()) {
			handleBadInput(scan, widthPrompt);
		}
		int width = scan.nextInt();

		String heightPrompt = "Please enter the height of a rectangle (as an integer): ";
		System.out.print(heightPrompt);

		// check for bad input
		while (!scan.hasNextInt()) {
			handleBadInput(scan, heightPrompt);
		}
		int length = scan.nextInt();
		scan.close();

		System.out
				.println("The area of your square is " + length * width + ".");
	}


	/**
	 * When the user enters bad input, remove the rest of what's on the line
	 * from the scanner and print out an error message and a reminder of what
	 * the input should look like.
	 * 
	 * @param scan
	 *            where the bad input is coming from
	 * @param prompt
	 *            a reminder of what we're looking for
	 */
	public static void handleBadInput(Scanner scan, String prompt) {
		// read the bad input (up to the \n, which is what the user
		// entered to trigger reading the input)
		scan.nextLine();

		// give an error message, repeating what we want
		System.out.println("Incorrect input.");
		System.out.println(prompt);
	}


}
