/**
 * Demonstrates different equals with Strings
 * Run as
 *   java Equals <command-line argument>
 * @author Sara Sprenkle
 */
public class Equals {

    public static void main(String args[]) {
        String string1 = "same";
        String string2 = string1;
        // The following statement doesn't create a _new_ String object/memory allocation
        // Java memory optimization
        String string3 = "same"; 
        String string4 = args[0]; //enter "same" as a command-line argument
        
        System.out.println("string1 == string2? " + (string1==string2));
        System.out.println("string2 == string3? " + (string2==string3));
        System.out.println("string1 == string4? " + (string1==string4));
        // output should be
        // true
        // true
        // false, regardless of what user enters
        
        System.out.println("string1 equals string2? " + (string1.equals(string2)));
        System.out.println("string2 equals string3? " + (string2.equals(string3)));
        System.out.println("string1 equals string4? " + (string1.equals(string4)));
        
        // output should be
        // true
        // true
        // true
    }

}
