import java.awt.Graphics;

import java.awt.Color;

import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Demonstrates use of colors and drawing on a panel.
 * 
 */
public class ColorJPanel extends JPanel {

	public void paintComponent(Graphics g) {
		// draw rectangles and Strings in different colors

		super.paintComponent(g); // call superclass's paintComponent

		this.setBackground(Color.WHITE);

		// set new drawing color using integers
		g.setColor(new Color(255, 0, 0)); // would be better to extract the
											// color as a local variable: easier
											// to understand code.
		g.fillRect(15, 25, 100, 20);
		g.drawString("Current RGB: " + g.getColor(), 130, 40);

		// set new drawing color using floats
		g.setColor(new Color(0.50f, 0.75f, 0.0f));
		g.fillRect(15, 50, 100, 20);
		g.drawString("Current RGB: " + g.getColor(), 130, 65);

		// set new drawing color using static Color objects
		g.setColor(Color.BLUE);
		g.fillRect(15, 75, 100, 20);
		g.drawString("Current RGB: " + g.getColor(), 130, 90);

		// display individual RGB values
		Color color = Color.MAGENTA;
		g.setColor(color);
		g.fillRect(15, 100, 100, 20);
		g.drawString("RGB values: " + color.getRed() + ", " +

		color.getGreen() + ", " + color.getBlue(), 130, 115);

	}

	public static void main(String args[]) {
		// create frame for ColorJPanel
		JFrame frame = new JFrame("Using colors");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		ColorJPanel colorJPanel = new ColorJPanel(); // create ColorJPanel
		frame.add(colorJPanel); // add colorJPanel to frame
		frame.setSize(500, 180); // set frame size
		frame.setVisible(true); // display frame

	} 

} 

/*******************************************************************************
 * 
 * (C) Copyright 1992-2005 by Deitel & Associates, Inc. and Pearson Education,
 * Inc. All Rights Reserved.
 * Modified by SES for CSCI209
 ******************************************************************************/

