package examples;

import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * When a button is pressed, it colors the background of the panel the
 * appropriate color.
 * 
 * Uses a separate class to update the background.
 * 
 * @author sarasprenkle
 * 
 */
public class ColoredBackground2 extends JFrame {

	public ColoredBackground2() {
		setTitle("Colored Background - Separate class");
		setBackground(Color.white);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Container cp = getContentPane();
		cp.setLayout(new FlowLayout());

		// create buttons and add to content pane
		JButton red = new JButton("Red");
		red.setForeground(Color.red);

		JButton green = new JButton("Green");
		green.setForeground(Color.GREEN);

		JButton blue = new JButton("Blue");
		blue.setForeground(Color.blue);

		ColorAction greenAction = new ColorAction(Color.green, this);
		ColorAction blueAction = new ColorAction(Color.blue, this);
		ColorAction redAction = new ColorAction(Color.red, this);

		green.addActionListener(greenAction);
		blue.addActionListener(blueAction);
		red.addActionListener(redAction);

		cp.add(green);
		cp.add(red);
		cp.add(blue);

		pack();
		setVisible(true);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ColoredBackground cb = new ColoredBackground();
	}

}

/**
 * This class could (maybe *should*) go in its own file.
 * 
 */
class ColorAction implements ActionListener {
	private Color backgroundColor;
	private JFrame frame;

	public ColorAction(Color c, JFrame frame) {
		backgroundColor = c;
		this.frame = frame;
	}

	public void actionPerformed(ActionEvent evt1) {
		frame.setBackground(backgroundColor);
		//frame.repaint();
	}

}
