/**
 * A simple Java class that models a Chicken. The state of the chicken is its
 * name, height, weight, and gender.
 * 
 * Keeps instance variables private, rather than protected
 * 
 * @author Sara Sprenkle
 */
public class Chicken2 {

	// ------------ INSTANCE VARIABLES -------------------

    /** the chicken's name */
	private String name;
	
    /** the height of the chicken in centimeters */
	private int height;
    
    /** the weight of the chicken in pounds */
	private double weight;
    
    /** true iff the chicken is a female */
	private boolean isFemale;
    
    public static String DEFAULT_NAME = "BUBBA";

    public Chicken2(String name, int height, double weight, boolean isFemale ) {
        this.name = name;
		this.height = height;
		this.weight = weight;
        this.isFemale = isFemale;
    }
    
    /**
    * Assumes Chickens are females
    */
    public Chicken2(String name, int height, double weight) {
		this( name, height, weight, true );
	}
    
    /**
     * Default name is Bubba; Assumes Chickens are female
     */
    public Chicken2( int height, double weight ) {
        this( DEFAULT_NAME, height, weight, true);
    }
    
    /**
     * Returns a string representation of the chicken.
     * Format:
     * Chicken name: <name>
     * weight: <weight>
     * height: <height>
     * female/male
     */
    public String toString() {
        StringBuffer rep = new StringBuffer("Chicken name: ");
        rep.append(name);
        rep.append("\nweight: ");
        rep.append(weight);
        rep.append("\nheight: ");
        rep.append(height);
        rep.append("\n");
        rep.append( isFemale? "female" : "male"); // Java ternary operator; also available in C
        return rep.toString();
    }

    /**
     * Determines if two Chickens are equivalent, based on their
     * name, height, weight, and gender.
     */
    public boolean equals(Object o) {
        
        if( o == this ) {
            return true;   
        }
        
        Chicken2 other = (Chicken2) o;
        
        if( ! other.getName().equals(this.getName() ) ) {
            return false;
        }
        
        if( other.getHeight() != this.getHeight() ) {
            return false;   
        }
        
        if( other.getWeight() != this.getWeight() ) {
            return false;   
        }
        
        if( this.isFemale() ) {
            return other.isFemale();
        } else {
            return ! other.isFemale();
        }
        
    }
    
	//
	// ----------- GETTER METHODS ------------
	// (also Accessor methods)

	/**
	 * @return the height of the chicken, in centimeters
	 */
	public int getHeight() {
		return height;
	}

	public double getWeight() {
		return weight;
	}

	public String getName() {
		return name;
	}
    
    public boolean isFemale() {
        return isFemale;   
    }
    

	//
	// ------------- MUTATORS -----------
	//

	public void feed() {
		weight += .2;
		height += 1;
	}
	
	//
	// ------------- SETTERS ----------
	//

	/**
	 * @param n
	 *            the name of the chicken
	 */
	public void setName(String n) {
		name = n;
	}

	/**
	 * @param h
	 *            the height of the chicken, in cm
	 */
	public void setHeight(int h) {
		height = h;
	}
    
    /**
	 * @param w
	 *            the weight of the chicken, in pounds
	 */
	public void setWeight(double w) {
		weight = w;
	}
    
	/**
	 * @param args
	 *            the command-line arguments
	 */
	public static void main(String args[]) {
        Chicken2 one = new Chicken2("Fred", 38, 2.0, false);
        Chicken2 two = new Chicken2("Sallie Mae", 45, 3.0);
        Chicken2 oneFemale = new Chicken2("Fred", 38, 2.0, true);
        
        System.out.println(one.getName() + " weighs " + one.getWeight() );
        one.feed();
        System.out.println(one.getName() + " ate, so he now weighs " + one.getWeight() );
        
        System.out.print(two.getName() + " is now ");
        two.setName("The Divine Miss Sallie Mae");
        System.out.println(two.getName());
        
        // test toString method
        System.out.println(one);
        
        System.out.println( one + " equal to " + two + "? " + one.equals(two) );
        System.out.println( one + " equal to " + oneFemale + "? " + one.equals(oneFemale) );
        System.out.println( two + " equal to " + two + "? " + two.equals(two) );

		
	}

}